import { Router } from 'express';
import { body, validationResult } from 'express-validator';
import { claimUpdate } from '../controllers/claim.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const claimValidation = [
    body('claim').isArray({ min: 1 }).withMessage('At least one claim ID is required'),
    body('status').notEmpty().withMessage('Status is required'),
    body('remarks').optional().isString()
];

router.post('/update', verifyToken, claimValidation, async (req, res) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
        return res.status(400).json({
            code: 400,
            status: false,
            message: 'Validation failed',
            response: errors.array()
        });
    }

    await claimUpdate(req, res);
});

export default router;