import { Router } from 'express';
import { body } from 'express-validator';
import { createCompany, updateCompany, deleteCompany, listCompanies, getCompanyList } from '../controllers/company.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const companyValidation = [
    body('company_id').notEmpty().withMessage('Company ID is required'),
    body('company_name').notEmpty().withMessage('Company name is required'),
    body('company_address').notEmpty().withMessage('Company address is required'),
    body('company_lat').isFloat().withMessage('Valid latitude is required'),
    body('company_long').isFloat().withMessage('Valid longitude is required'),
    body('radius').isFloat().withMessage('Valid radius is required'),
    body('email').isEmail().withMessage('Valid email is required'),
    body('mobile_no').matches(/^[0-9]{10}$/).withMessage('Valid 10-digit mobile number is required'),
    body('branch_id').notEmpty().withMessage('Branch ID is required')
];

router.post('/', verifyToken, companyValidation, createCompany);
router.put('/:id', verifyToken, companyValidation, updateCompany);
router.delete('/:id', verifyToken, deleteCompany);
router.get('/', verifyToken, listCompanies);
router.get('/datatable', verifyToken, getCompanyList);

export default router;