import { Router } from 'express';
import { body } from 'express-validator';
import { createContact, updateContact, deleteContact, listContacts, listActiveContactsByCompany, getContactDetailsPage, datatablecontacts } from '../controllers/contact.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const contactValidation = [
    body('contact_name').notEmpty().withMessage('Contact name is required'),
    body('email').isEmail().withMessage('Valid email is required'),
    body('mobile_no').matches(/^[0-9]{10}$/).withMessage('Valid 10-digit mobile number is required'),
    body('designation').notEmpty().withMessage('Designation is required'),
    body('company_id').notEmpty().withMessage('Company ID is required')
];

router.post('/', verifyToken, contactValidation, createContact);
router.put('/:id', verifyToken, contactValidation, updateContact);
router.delete('/:id', verifyToken, deleteContact);
router.get('/', verifyToken, listContacts);
router.get('/company/:companyId/active', verifyToken, listActiveContactsByCompany);
router.get('/contact/:id/page', verifyToken, getContactDetailsPage);
router.get('/datatable-contacts', verifyToken, datatablecontacts);

export default router;