import express from 'express';
import { adminConveyance, getConveyance, getConveyanceByUserId, getClaims, getFinanceClaims, updateClaimStatus, datatableclaims, datatableFinanceClaims } from '../controllers/conveyance.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = express.Router();

router.put("/claims/:id", updateClaimStatus);


router.get("/claims", getClaims);

router.get("/finance-claims", verifyToken, getFinanceClaims);

router.get('/datatable-claims', datatableclaims);

router.get('/datatable-finance-claims', verifyToken, datatableFinanceClaims);


router.post('/admin-conveyance', verifyToken, adminConveyance);

router.get("/", getConveyance);

router.get("/:id", getConveyanceByUserId);


export default router;