import { Router } from 'express';
import { body } from 'express-validator';
import { listConfig, updateConfig } from '../controllers/conveyanceconfig.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const configValidation = [
    body('transport_mode').notEmpty().withMessage('Transport mode is required'),
    body('conveyance_charge').isNumeric().withMessage('Conveyance charge must be a number')
];

router.get('/', verifyToken, listConfig);
router.put('/:id', verifyToken, configValidation, updateConfig);

export default router;