import { Router } from 'express';
import { body, validationResult } from 'express-validator';
import { financeClaimUpdate } from '../controllers/financeclaim.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const financeClaimValidation = [
    body('claim').isArray({ min: 1 }).withMessage('At least one claim ID is required'),
    body('status').notEmpty().withMessage('Status is required'),
    body('remarks').optional().isString()
];

router.post('/update', verifyToken, financeClaimValidation, financeClaimUpdate);

export default router;