import { Router } from 'express';
import { verifyToken } from '../middleware/auth.js';
import { createNotification, listNotifications, updateNotification } from '../controllers/firebaseinbox.controller.js';

const router = Router();

router.post('/firebase-notification', verifyToken, createNotification);
router.get('/firebase-notification', verifyToken, listNotifications);
router.put('/firebase-notification/:id', verifyToken, updateNotification);

export default router;