// src/routes/index.js

import express from 'express';
import authRoutes from './auth.routes.js';
import roleRoutes from './role.routes.js';
import userRoutes from './user.routes.js';
import branchRoutes from './branch.routes.js';
import productRoutes from './product.routes.js';
import packageRoutes from './package.routes.js';
import taskTypeRoutes from './tasktype.routes.js';
import companyRoutes from './company.routes.js';
import contactRoutes from './contact.routes.js';
import projectRoutes from './project.routes.js';
import projectAssigneeRoutes from './projectassignee.routes.js';
import taskSubcategoryRoutes from './tasksubcategory.routes.js';
import Controller from '../controllers/index.js';
import appAuthRoutes from './appauth.routes.js';
import appVersionRoutes from './appversion.routes.js';
import attendanceConfigRoutes from './attendanceconfig.routes.js';
import conveyanceConfigRoutes from './conveyanceconfig.routes.js';
import taskRoutes from './task.routes.js';
import taskroughtRoutes from './taskrought.js';
import attendanceRoutes from './attendanceroutes.js';
import conveyanceRoutes from './conveyance.routes.js';
import locationRoutes from './location.routes.js';
import profileRoutes from './profile.js';
import profileUpdateRoutes from './profileupdate.js';
import taskRolewiseRoutes from './taskrolewise.js';
import projectRolewiseRoutes from './projectrolewise.js';
import attendanceRolewiseRoutes from './attendancerolewise.js';
import conveyanceRolewiseRoutes from './conveyancerolewise.js';
import claimRoutes from './claim.routes.js';
import financeClaimRoutes from './financeclaim.routes.js';
import dashboardRoutes from './dashboard.routes.js';
import customerRoutes from './customer.routes.js';
import firebaseInboxRoutes from './firebaseinbox.routes.js';
import homeApprovalRoutes from './homeapproval.routes.js';
import deviceApprovalRoutes from './deviceapproval.routes.js';
import actionReportRoutes from './actionReport.routes.js';
import claimReportRoutes from './claimReport.routes.js';
import checkoutReportRoutes from './checkoutReport.routes.js';
import managerRoutes from './manager.routes.js';
import attendanceresetRoutes from './attendancereset.routes.js';
import branchusersRoutes from './branchusers.routes.js';
import projectReportRoutes from './projectReport.routes.js';
import deviceUpdateRoutes from './deviceupdate.routes.js';
import forceCheckoutRoutes from './forcecheckout.routes.js';

if (typeof globalThis.File === 'undefined') {
    globalThis.File = (await import('node:buffer')).File;
}
const router = express.Router();
const controller = new Controller();

export const setRoutes = (app) => {
    // API Health Check
    app.get('/api/health', (req, res) => {
        res.status(200).json({
            status: 200,
            message: 'API is running',
            timestamp: new Date(), 
            environment: process.env.NODE_ENV || 'development'
        });
    });

    // Auth routes
    app.use('/api/auth', authRoutes);

    // Role routes
    app.use('/api/roles', roleRoutes);

    // User routes
    app.use('/api/users', userRoutes);

    // Branch routes
    app.use('/api/branches', branchRoutes);

    // Product routes
    app.use('/api/products', productRoutes);

    // Package routes
    app.use('/api/packages', packageRoutes);

    // Task Type routes
    app.use('/api/tasktypes', taskTypeRoutes);

    // Company routes
    app.use('/api/companies', companyRoutes);

    // Contact routes
    app.use('/api/contacts', contactRoutes);

     // Customer routes
    app.use('/api/customers', customerRoutes);

    // Project routes
    app.use('/api/projects', projectRoutes);

    // Project Assignee routes
    app.use('/api/project-assignees', projectAssigneeRoutes);

    // Task Subcategory routes
    app.use('/api/task-subcategories', taskSubcategoryRoutes);

    // App-specific Auth routes
    app.use('/api/app', appAuthRoutes);

    // App Version routes
    app.use('/api/app-version', appVersionRoutes);

    // Attendance Config routes
    app.use('/api/attendance-config', attendanceConfigRoutes);

    // Conveyance Config routes
    app.use('/api/conveyance-config', conveyanceConfigRoutes);

    // Task Routes
    app.use('/api/tasks', taskRoutes);

    // tasklist routes
    app.use('/api/task', taskroughtRoutes);
    // Profile routes
    app.use('/api/profile', profileRoutes);
    // Profile Update Routes
    app.use('/api/profile', profileUpdateRoutes);
    // Attendance Routes
    app.use('/api/attendance', attendanceRoutes);
    // Conveyance Config routes
    app.use('/api/conveyance', conveyanceRoutes);
     // Task Rolewise Routes
    app.use('/api/task-rolewise', taskRolewiseRoutes);
    // Project Rolewise Routes
    app.use('/api/projects-rolewise', projectRolewiseRoutes);
    // Attendance Rolewise Routes
     app.use('/api/attendance-rolewise', attendanceRolewiseRoutes);
    // Conveyance Rolewise Routes
    app.use('/api/conveyance-rolewise', conveyanceRolewiseRoutes);
    // Claim routes
    app.use('/api/claim', claimRoutes);
    // Finance Claim routes
    app.use('/api/finance-claim', financeClaimRoutes);
    // Dashboard Routes
    app.use('/api/dashboard', dashboardRoutes);
    // Location Routes
    app.use('/api/location', locationRoutes);
     // Firebase Inbox Routes
    app.use('/api/notification', firebaseInboxRoutes);
    // Home Approval Routes
    app.use('/api/home-approval', homeApprovalRoutes);
    // Device Approval Routes
    app.use('/api/device-approval', deviceApprovalRoutes);
    // Action report
    app.use('/api/action-report', actionReportRoutes);
    //Claim report
    app.use('/api/claim-report', claimReportRoutes);
    // checkout report routes
    app.use('/api/checkout-report', checkoutReportRoutes);
    app.use('/api/managers', managerRoutes);
    // Attendance Reset Routes
    app.use('/api/attendance-reset', attendanceresetRoutes);
    app.use('/api/branchuser', branchusersRoutes);
    app.use('/api/projectreport', projectReportRoutes);
    // Device Update Route
    app.use('/api/deviceupdate', deviceUpdateRoutes);
    // Force Checkout Route
    app.use('/api', forceCheckoutRoutes);
    // Other routes
    router.get('/endpoint', controller.handleGetRequest);
    router.post('/endpoint', controller.handlePostRequest);

    app.use('/api', router);

    // Handle 404 - Route not found
    app.use('*', (req, res) => {
        res.status(404).json({
            status: 404,
            message: 'Route not found'
        });
    });
};