import { Router } from 'express';
import { body } from 'express-validator';
import { createPackage, updatePackage, deletePackage, listPackages, getPackageDetails } from '../controllers/package.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const packageValidation = [
    body('package_name').notEmpty().withMessage('Package name is required'),
    body('products').isArray().withMessage('Products must be an array')
];

router.post('/', verifyToken, packageValidation, createPackage);
router.put('/:id', verifyToken, packageValidation, updatePackage);
router.delete('/:id', verifyToken, deletePackage);
router.get('/', verifyToken, listPackages);
router.get('/:id/details', verifyToken, getPackageDetails);

export default router;