import { Router } from 'express';
import { body } from 'express-validator';
import { createProduct, updateProduct, deleteProduct, listProducts, getProductChecklists } from '../controllers/product.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const productValidation = [
    body('name').notEmpty().withMessage('Product name is required'),
    body('internal_name').notEmpty().withMessage('Internal name is required')
];

router.post('/', verifyToken, productValidation, createProduct);
router.put('/:id', verifyToken, productValidation, updateProduct);
router.delete('/:id', verifyToken, deleteProduct);
router.get('/', verifyToken, listProducts);
router.get('/checklists/:product_id', verifyToken, getProductChecklists);

export default router;