import express from 'express';
import multer from 'multer';
import path from 'path';
import { profileUpdate } from '../controllers/profile.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = express.Router();

// Create storage configuration similar to task controller
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/profiles/');
    },
    filename: function (req, file, cb) {
        // Get the base name (without extension)
        const originalName = file.originalname;
        const ext = path.extname(originalName);
        const basename = path.basename(originalName, ext);
        
        // Create unique filename with original extension
        const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1E9);
        cb(null, basename + '-' + uniqueSuffix + ext);
    }
});

// Add file filter for images
const fileFilter = (req, file, cb) => {
    if (file.mimetype.startsWith('image/')) {
        cb(null, true);
    } else {
        cb(new Error('Not an image! Please upload an image.'), false);
    }
};

const uploadProfile = multer({ 
    storage: storage,
    fileFilter: fileFilter,
    limits: {
        fileSize: 1024 * 1024 * 5 // 5MB limit
    }
});

router.post('/update', verifyToken, uploadProfile.single('profile'), profileUpdate);

export default router;
