import { Router } from 'express';
import { body, header } from 'express-validator';
import { createProject, updateProject, deleteProject, listProjects, getAssignedProjects, getProjectDetails, projectFilterList, getProjectAdminDetails, updateProjectStatus, addProjectWarranty, editProjectWarranty, deleteProjectWarranty, getProjectProducts, viewProjectWithPackages } from '../controllers/project.controller.js';
import { verifyToken, validateDeviceToken } from '../middleware/auth.js';

const router = Router();

const projectValidation = [
    body('customer_id').notEmpty().withMessage('Customer ID is required'),
    body('start_date').isDate().withMessage('Valid start date is required'),
    body('closure_date').isDate().withMessage('Valid closure date is required'),
    body('project_manager').notEmpty().withMessage('Project manager is required'),
    body('package').notEmpty().withMessage('Package is required')
];

router.post('/', verifyToken, projectValidation, createProject);
router.put('/:id', verifyToken, projectValidation, updateProject);
router.put('/status/:id', verifyToken, updateProjectStatus);
router.delete('/:id', verifyToken, deleteProject);
router.get('/', verifyToken, listProjects);
router.get('/assigned', 
    verifyToken, 
    header('device-token').notEmpty().withMessage('Device token is required'),
    validateDeviceToken,
    getAssignedProjects
);
router.get('/:id/details', 
    verifyToken,
    getProjectDetails
);
router.get('/project-filter', verifyToken, listProjects); // New route added here
router.get('/project-filter-list', verifyToken, projectFilterList);
router.get('/:id/admin-details', 
    verifyToken,
    getProjectAdminDetails
);
router.post('/warranty', verifyToken, addProjectWarranty);
router.put('/warranty/:id', verifyToken, editProjectWarranty);
router.delete('/warranty/:id', verifyToken, deleteProjectWarranty);
router.get('/:id/products', verifyToken, getProjectProducts);
router.get('/project/:projectId/view-with-packages', verifyToken, viewProjectWithPackages);
export default router;