import express from 'express';
import { ProjectModuleController } from '../controllers/projectModule.controller.js';

const router = express.Router();

// Create a new project module
router.post('/', ProjectModuleController.create);

// Get all project modules
router.get('/', ProjectModuleController.getAll);

// Get a single project module by ID
router.get('/:id', ProjectModuleController.getById);

// Update a project module
router.put('/:id', ProjectModuleController.update);

// Delete a project module
router.delete('/:id', ProjectModuleController.delete);

export default router;