import { Router } from 'express';
import { body } from 'express-validator';
import { createAssignee, updateAssignee, deleteAssignee, listAssignees, listgetAssignees } from '../controllers/projectassignee.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const assigneeValidation = [
    body('project_id').notEmpty().withMessage('Project ID is required'),
    body('user_id').notEmpty().withMessage('User ID is required')
];

router.post('/', verifyToken, assigneeValidation, createAssignee);
router.put('/:id', verifyToken, assigneeValidation, updateAssignee);
router.delete('/:id', verifyToken, deleteAssignee);
router.get('/:project_id', verifyToken, listAssignees);
router.post('/get-project-assignees', verifyToken, listgetAssignees);

export default router;