import { Router } from 'express';
import { body } from 'express-validator';
import { createRole, updateRole, deleteRole, listRoles } from '../controllers/role.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const roleValidation = [
    body('name').notEmpty().withMessage('Name is required'),
    body('scope').notEmpty().withMessage('Scope is required'),
    body('reporting_to').notEmpty().withMessage('Reporting to is required'),
    body('location').notEmpty().withMessage('Location is required'),
    body('eligible_transport').notEmpty().withMessage('Eligible transport is required'),
    body('default_transport').notEmpty().withMessage('Default transport is required'),
    body('access_scope').notEmpty().withMessage('Access scope is required')
];

router.post('/', verifyToken, roleValidation, createRole);
router.put('/:id', verifyToken, roleValidation, updateRole);
router.delete('/:id', verifyToken, deleteRole);
router.get('/', verifyToken, listRoles);

export default router;