import { Router } from 'express';
import { body } from 'express-validator';
import { createTask, updateTask, getUserTaskDashboard, updateTaskStatus,createAttendanceTasks, filterTasks, attendanceHistory, conveyance, viewConveyance, addClaim, readdClaim, modeOfTransport, applyClaimList, applyClaim, claimHistory, addTaskNote, viewTaskDetails, taskActionList, aiTaskFromVoicenote, extractTextFromVoicenote, updateOtherTaskStatus } from '../controllers/task.controller.js';
import { verifyToken } from '../middleware/auth.js';
import multer from 'multer';
import path from 'path';

const router = Router();
const upload = multer({ dest: 'uploads/' }); // configure as needed
const storageTaskNote = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/tasknotes/');
    },
    filename: function (req, file, cb) {
        // Get only the base name (without any extension)
        const originalName = file.originalname;
        const ext = path.extname(originalName);
        const basename = path.basename(originalName, ext);
        const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1E9);
        cb(null, basename + '-' + uniqueSuffix + ext);
        console.log('app filename:', originalName);
    }
});
const uploadTaskNote = multer({ storage: storageTaskNote });
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/taskuploads/');
    },
    filename: function (req, file, cb) {
        const originalName = file.originalname;
        const ext = path.extname(originalName);
        const basename = path.basename(originalName, ext);
        const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1E9);
        cb(null, basename + '-' + uniqueSuffix + ext);
        
        console.log('app filename:', originalName);
    }
});
const uploadfile = multer({ storage });
const statusupload = multer();
const storageVoicenote = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/tasknotes/');
    },
    filename: function (req, file, cb) {
        const originalName = file.originalname;
        const ext = path.extname(originalName);
        const basename = path.basename(originalName, ext);
        const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1E9);
        cb(null, basename + '-' + uniqueSuffix + ext);

        console.log('app filename:', originalName);
        
    }
});
const uploadVoicenote = multer({ storage: storageVoicenote });

const taskValidation = [
    // Only require project_id if tasktype_id is NOT 8
    body('project_id')
        .if((value, { req }) => req.body.tasktype_id != 8)
        .notEmpty().withMessage('Project ID is required'),

    body('task').notEmpty().withMessage('Task title is required'),
    body('start_date').isDate().withMessage('Valid start date is required'),
    body('start_time').notEmpty().withMessage('Start time is required'),
    body('tasktype_id').notEmpty().withMessage('Task type is required'),

    // Only require tasksubcategory_id if tasktype_id is not 6 or 8
    body('tasksubcategory_id')
        .if((value, { req }) => req.body.tasktype_id != 6 && req.body.tasktype_id != 8)
        .notEmpty().withMessage('Task subcategory is required'),

    // Only require product_id if tasktype_id is not 6 or 8
    body('product_id')
        .if((value, { req }) => req.body.tasktype_id != 6 && req.body.tasktype_id != 8)
        .notEmpty().withMessage('Product235 is required'),

    // Only require taskcategoryoption_id if tasktype_id is not 6 or 8
    body('taskcategoryoption_id')
        .if((value, { req }) => req.body.tasktype_id != 6 && req.body.tasktype_id != 8)
        .notEmpty().withMessage('Task category option is required')
];

router.post('/', verifyToken, taskValidation, createTask);
router.put('/:id', verifyToken, taskValidation, updateTask);
router.get('/attendance', createAttendanceTasks);
router.get('/dashboard', verifyToken, getUserTaskDashboard);
//router.put('/status/:id', verifyToken, upload.single('checkout_file'), updateTaskStatus);
router.put(
    '/status/:id',
    verifyToken,
    uploadfile.fields([
        { name: 'claim_image', maxCount: 1 },
        { name: 'task_files', maxCount: 10 },
        { name: 'voicenote', maxCount: 1 }
    ]),
    updateTaskStatus
);
router.put(
    '/otherstatus/:id',
    verifyToken,
    statusupload.none(),  // multer parses form-data after token is verified
    updateOtherTaskStatus
);
router.post('/filter', verifyToken, filterTasks);
router.get('/attendance-history', verifyToken, attendanceHistory);
router.post('/conveyance', verifyToken, conveyance);
router.post('/view-conveyance', verifyToken, viewConveyance);
router.post('/add-claim', verifyToken, upload.array('uploadfile'), addClaim);
router.post('/readd-claim', verifyToken, upload.array('uploadfile'), readdClaim);
router.get('/mode-of-transport', verifyToken, modeOfTransport);
router.post('/apply-claim-list', verifyToken, applyClaimList);
router.post('/apply-claim', verifyToken, applyClaim);
router.post('/claim-history', verifyToken, claimHistory);
router.post('/add-task-note', verifyToken, uploadTaskNote.single('file'), addTaskNote);
router.get('/task/:id/details', verifyToken, viewTaskDetails);
router.post('/task-action-list', verifyToken, taskActionList);
router.post(
  '/ai-task-from-voicenote',
  uploadfile.fields([{ name: 'voicenote', maxCount: 1 }]),
  aiTaskFromVoicenote
);
router.post(
  '/extract-text-from-voicenote',
  uploadfile.fields([{ name: 'voicenote', maxCount: 1 }]),
  extractTextFromVoicenote
);
export default router;