import express from "express";
import { getTasks, getTaskById, createTask, updateTask } from "../controllers/taskcontroller.js";
import { verifyToken } from "../middleware/auth.js";
const router = express.Router();

router.use(verifyToken);

router.get("/", getTasks);
router.get("/:id", getTaskById); 
router.post("/", createTask);
router.put("/:id", updateTask);

export default router;