import { Router } from 'express';
import { body } from 'express-validator';
import { createSubcategory, updateSubcategory, deleteSubcategory, listSubcategories, getByTaskType, viewSubcategoryById } from '../controllers/tasksubcategory.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const optionValidation = [
    body('product_id').optional().isInt().withMessage('Product ID must be an integer'),
    body('dropdown').notEmpty().withMessage('Dropdown value is required')
];

const subcategoryValidation = [
    body('tasktype_id').notEmpty().withMessage('Task type ID is required'),
    body('subcategory').notEmpty().withMessage('Subcategory name is required'),
    body('options').isArray().withMessage('Options must be an array'),
    body('options.*').custom((value) => {
        if (!value.dropdown) {
            throw new Error('Dropdown value is required for each option');
        }
        return true;
    })
];

router.post('/', verifyToken, subcategoryValidation, createSubcategory);
router.put('/:id', verifyToken, subcategoryValidation, updateSubcategory);
router.delete('/:id', verifyToken, deleteSubcategory);
router.get('/', verifyToken, listSubcategories);
router.get('/subcategory/:id', viewSubcategoryById);
router.get('/by-tasktype/:tasktype_id', verifyToken, getByTaskType);

export default router;