import { Router } from 'express';
import { body } from 'express-validator';
import { createTaskType, updateTaskType, deleteTaskType, listTaskTypes, getActiveTaskTypesExceptOne } from '../controllers/tasktype.controller.js';
import { verifyToken } from '../middleware/auth.js';
import { upload } from '../utils/upload.js';

const router = Router();

const taskTypeValidation = [
    body('activity_id').notEmpty().withMessage('Activity ID is required'),
    body('activity_name').notEmpty().withMessage('Activity name is required'),
    body('allow_checkin_checkout').isBoolean(),
    body('allow_startdate_enddate').isBoolean(),
    body('show_calendar').isBoolean(),
    body('mark_completed').isBoolean(),
    body('allow_claim').isBoolean(),
    body('allow_edit').isBoolean()
];

router.post('/', verifyToken, upload.single('activity_icon'), taskTypeValidation, createTaskType);
router.put('/:id', verifyToken, upload.single('activity_icon'), taskTypeValidation, updateTaskType);
router.delete('/:id', verifyToken, deleteTaskType);
router.get('/', verifyToken, listTaskTypes);
router.get('/activetasktypes', getActiveTaskTypesExceptOne);

export default router;