import { Router } from 'express';
import { body } from 'express-validator';
import { createUser, updateUser, deleteUser, listUsers, getUsersByRole, changePassword, logout, updateHomeLocation, getAssignableUsers, datatableusers } from '../controllers/user.controller.js';
import { verifyToken } from '../middleware/auth.js';

const router = Router();

const userValidation = [
    body('branch_id').notEmpty().withMessage('Branch ID is required'),
    body('emp_id').notEmpty().withMessage('Employee ID is required'),
    body('name').notEmpty().withMessage('Name is required'),
    body('email').isEmail().withMessage('Valid email is required'),
    body('mobile').matches(/^[0-9]{10}$/).withMessage('Valid 10-digit mobile number is required'),
    body('roles_id').notEmpty().withMessage('Role ID is required')
];

router.post('/', verifyToken, userValidation, createUser);
router.put('/:id', verifyToken, userValidation, updateUser);
router.delete('/:id', verifyToken, deleteUser);
router.get('/', verifyToken, listUsers);
router.get('/by-role/:roleId', verifyToken, getUsersByRole);
router.post('/change-password', verifyToken, changePassword);
router.post('/logout', verifyToken, logout);
router.post('/home-location', verifyToken, updateHomeLocation);
router.get('/assignable-users', verifyToken, getAssignableUsers);
router.get('/datatable-users', verifyToken, datatableusers);

export default router;