import openai from './openaiClient.js'; // ✅ Correct

export async function extractTaskDetails(transcript) {
    const prompt = `
Extract the following fields from the text:
- Project Name
- Task Type
- Assigned Engineer
- Task Date
- Task Time

Text: """${transcript}"""

Return as JSON with keys: project_name, task_type, assigned_engineer, task_date, task_time.
`;

    const completion = await openai.chat.completions.create({
        model: 'gpt-3.5-turbo',
        messages: [{ role: 'user', content: prompt }],
        temperature: 0
    });

    const json = JSON.parse(completion.choices[0].message.content);
    return json;
}