import CryptoJS from 'crypto-js';

const SECRET_KEY = process.env.VITE_SECRET_KEY || 'ezone-projects-24-09-2025';

export const encrypt = (text) => {
    if (!text) return null;
    return CryptoJS.AES.encrypt(text, SECRET_KEY).toString();
};

export const decrypt = (encryptedText) => {
    if (!encryptedText) return null;
    const bytes = CryptoJS.AES.decrypt(encryptedText, SECRET_KEY);
    return bytes.toString(CryptoJS.enc.Utf8);
};