const admin = require('firebase-admin');
const path = require('path');

try {
    // Initialize firebase admin with service account
    const serviceAccount = require('./firebase-service-account.json');
    
    if (!admin.apps.length) {
        admin.initializeApp({
            credential: admin.credential.cert(serviceAccount),
            projectId: serviceAccount.project_id
        });
    }

    console.log('Firebase Admin initialized successfully');
} catch (error) {
    console.error('Firebase Admin initialization error:', error);
    throw new Error(`Firebase Admin initialization failed: ${error.message}`);
}

module.exports = admin;