import openai from './openaiClient.js';
import fs from 'fs';

export async function transcribeAudio(filePath) {
    const audioStream = fs.createReadStream(filePath);

   
    // Without language
    const transcription = await openai.audio.translations.create({
        file: audioStream,
        model: 'whisper-1',
        task: 'translate'
    });

    //console.log('Transcription:', transcription);
    return transcription; // Should be English if translation is supported
}